CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGAGRUPCONVHIST" ("CODAGRUP", "DESCAGRUP", "DESEAGRUP", "CODCONVENIO", "DESCCONVENIO", 
  "DESECONVENIO", "CODSINDICATO", "SINDDESC", "SINDDESE", "NACTA", "ANOACTA", "TERRIT", "VER", "FELEC", 
  "FECHAREGISTRO", "FECHABAJA", "NUMDELEGADOS","FECHAACTU") AS 
  SELECT   consulta.codagrup, consulta.descagrup, consulta.deseagrup,
            consulta.codconvenio, consulta.descconvenio,
            consulta.deseconvenio, consulta.codsindicato, consulta.sinddesc,
            consulta.sinddese, consulta.nacta, consulta.anoacta,
            consulta.territ, consulta.ver, consulta.felec,
            consulta.fecharegistro, consulta.fechabaja, consulta.numdelegados,
			consulta.fechaactu
       FROM (SELECT   agrupaciones.c_agru_014 AS codagrup,
                      agrupaciones.desc_014 AS descagrup,
                      agrupaciones.dese_014 AS deseagrup,
                      convenios.c_conv_013 AS codconvenio,
                      convenios.desc_013 AS descconvenio,
                      convenios.dese_013 AS deseconvenio,
                      sindicatos.c_sindi_019 AS codsindicato,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.dese_019 AS sinddese,
                      actas.n_acta_016 AS nacta,
                      actas.ano_acta_016 AS anoacta,
                      actas.c_territ_016 AS territ, actas.version_016 AS ver,
                      actas.f_elecc_016 AS felec,
                      actas.fregdef_016 AS fecharegistro,
                      actas.f_baja_016 AS fechabaja,
                      NVL (SUM (escrutinios.n_delm_024
                                + escrutinios.n_delh_024
                               ),
                           '0'
                          ) AS numdelegados,
					actas.factu_016 AS fechaactu
                 FROM w83b16s00 actas,
                      w83b24s00 escrutinios,
                      w83b13s00 convenios,
                      w83b19s00 sindicatos,
                      w83b15s00 convagrup,
                      w83b14s00 agrupaciones
                WHERE actas.n_acta_016 = escrutinios.n_acta_024
                  AND actas.ano_acta_016 = escrutinios.ano_acta_024
                  AND actas.c_territ_016 = escrutinios.c_territ_024
                  AND actas.version_016 = escrutinios.version_024
                  AND actas.c_conv_016 = convenios.c_conv_013
                  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
                  AND convenios.c_conv_013 = convagrup.c_conv_015
                  AND convagrup.c_agru_015 = agrupaciones.c_agru_014(+)
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
                  AND actas.n_regdef_016 IS NOT NULL
                 -- AND actas.f_baja_016 IS NULL
             GROUP BY agrupaciones.c_agru_014,
                      agrupaciones.desc_014,
                      agrupaciones.dese_014,
                      convenios.c_conv_013,
                      convenios.desc_013,
                      convenios.dese_013,
                      sindicatos.c_sindi_019,
                      sindicatos.desc_019,
                      sindicatos.dese_019,
                      actas.n_acta_016,
                      actas.ano_acta_016,
                      actas.c_territ_016,
                      actas.version_016,
                      actas.f_elecc_016,
                      actas.fregdef_016,
                      actas.f_baja_016,
					  actas.factu_016
             UNION ALL
             SELECT   agrupaciones.c_agru_014 AS codagrup,
                      agrupaciones.desc_014 AS descagrup,
                      agrupaciones.dese_014 AS deseagrup,
                      convenios.c_conv_013 AS codconvenio,
                      convenios.desc_013 AS descconvenio,
                      convenios.dese_013 AS deseconvenio,
                      sindicatos.c_sindi_019 AS codsindicato,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.dese_019 AS sinddese,
                      actas.n_acta_016 AS nacta,
                      actas.ano_acta_016 AS anoacta,
                      actas.c_territ_016 AS territ, actas.version_016 AS ver,
                      actas.f_elecc_016 AS felec,
                      actas.fregdef_016 AS fecharegistro,
                      actas.f_baja_016 AS fechabaja,
                      NVL (SUM (diferencias.n_delm_018
                                + diferencias.n_delh_018
                               ),
                           '0'
                          ) AS numdelegados,
						    actas.factu_016                                                    AS fechaactu
                 FROM w83b16s00 actas,
                      w83b18s00 diferencias,
                      w83b13s00 convenios,
                      w83b19s00 sindicatos,
                      w83b15s00 convagrup,
                      w83b14s00 agrupaciones
                WHERE actas.n_acta_016 = diferencias.n_acta_018
                  AND actas.ano_acta_016 = diferencias.ano_acta_018
                  AND actas.c_territ_016 = diferencias.c_territ_018
                  AND actas.version_016 = diferencias.version_018
                  AND actas.c_conv_016 = convenios.c_conv_013
                  AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
                  AND convenios.c_conv_013 = convagrup.c_conv_015
                  AND convagrup.c_agru_015 = agrupaciones.c_agru_014(+)
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.f_baja_016 IS NULL
             GROUP BY agrupaciones.c_agru_014,
                      agrupaciones.desc_014,
                      agrupaciones.dese_014,
                      convenios.c_conv_013,
                      convenios.desc_013,
                      convenios.dese_013,
                      sindicatos.c_sindi_019,
                      sindicatos.desc_019,
                      sindicatos.dese_019,
                      actas.n_acta_016,
                      actas.ano_acta_016,
                      actas.c_territ_016,
                      actas.version_016,
                      actas.f_elecc_016,
                      actas.fregdef_016,
                      actas.f_baja_016,
					 actas.factu_016 )
					 consulta    
   ORDER BY consulta.codagrup, consulta.codconvenio, consulta.codsindicato;


  CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSCNAE" ("NACTA", "ANOACTA", "TERRIT", "VER", "NCENTRO", "TOTALELECTORES", "FELEC", "FECHAREGISTRO", "IDCNAE", "SECTOR", "DESCSECTOR", "DESCCNAE", "C_SINDI_024", "C_COLEG_024", "N_VOTOS_024", "N_DELH_024", "N_DELM_024", "SIGLAS_019", "FECHABAJA") AS 
  (SELECT   tact.n_acta_016, tact.ano_acta_016, tact.c_territ_016,
             tact.version_016, tact.id_centro_016, tact.totelec_016,
             tact.f_elecc_016, tact.fregdef_016, tcent.cnae_001,
             tcnae.idsector, tsec.desc_004,
             NVL (tcnae.desccnae, 'cnae desconocido-' || tcent.cnae_001),
             tsind.c_sindi_019, tesc.c_coleg_024, SUM (papeletas.vota_044),
             NVL (tesc.n_delh_024, 0), NVL (tesc.n_delm_024, 0),
             tsind.siglas_019, tact.f_baja_016
        FROM w83b16t00 tact,
             w83b.j7301s01 tcent,
             w83bcnae tcnae,
             w83b24s00 tesc,
             w83b.j7304s00 tsec,
             w83b19s00 tsind,
             w83b44s00 papeletas
       WHERE tact.version_016 =
                (SELECT MAX (version_016)
                   FROM w83b16s00 act
                  WHERE tact.n_acta_016 = act.n_acta_016
                    AND tact.ano_acta_016 = act.ano_acta_016
                    AND tact.c_territ_016 = act.c_territ_016
                    AND act.validada_016 = 1)
         --AND tact.f_baja_016 IS NULL
         AND tact.n_acttot_016 IS NULL
         AND tact.n_regdef_016 IS NOT NULL
         --AND tact.fregdef_016 IS NOT NULL
         AND tact.id_centro_016 = tcent.ccen_001
         --AND tcent.cnae_001 = tcnae.idcnae(+)
         AND RPAD(replace(tcent.cnae_001,' ','0') ,4,'0')    = tcnae.idcnae(+)
         AND tcent.secc_001 = tcnae.idsector(+)
         AND tsec.secc_004 = tcent.secc_001
         AND tact.validada_016 = 1
         AND tact.n_acta_016 = tesc.n_acta_024(+)
         AND tact.ano_acta_016 = tesc.ano_acta_024(+)
         AND tact.c_territ_016 = tesc.c_territ_024(+)
         AND tact.version_016 = tesc.version_024(+)
         AND tesc.n_acta_024 = papeletas.n_acta_044(+)
         AND tesc.ano_acta_024 = papeletas.ano_acta_044(+)
         AND tesc.c_territ_024 = papeletas.c_territ_044(+)
         AND tesc.version_024 = papeletas.version_044(+)
         AND tesc.c_sindi_024 = tsind.c_sindi_019
    GROUP BY tact.n_acta_016,
             tact.ano_acta_016,
             tact.c_territ_016,
             tact.version_016,
             tact.id_centro_016,
             tact.totelec_016,
             tact.f_elecc_016,
             tact.fregdef_016,
             tcent.cnae_001,
             tcnae.idsector,
             tsec.desc_004,
             NVL (tcnae.desccnae, 'cnae desconocido-' || tcent.cnae_001),
             tsind.c_sindi_019,
             tesc.c_coleg_024,
             tesc.n_delh_024,
             tesc.n_delm_024,
             tsind.siglas_019,
             tact.f_baja_016)
   UNION ALL
   (SELECT tact.n_acta_016, tact.ano_acta_016, tact.c_territ_016,
           tact.version_016, tact.id_centro_016, tact.totelec_016,
           tact.f_elecc_016, tact.fregdef_016, tcent.cnae_001, tcnae.idsector,
           tsec.desc_004,
           NVL (tcnae.desccnae, 'cnae desconocido-' || tcent.cnae_001),
           tsind.c_sindi_019, tdif.c_coleg_018, 0 AS vota_044,
           NVL (tdif.n_delh_018, 0), NVL (tdif.n_delm_018, 0),
           tsind.siglas_019, tact.f_baja_016
      FROM w83b16t00 tact,
           w83b.j7301s01 tcent,
           w83bcnae tcnae,
           w83b.j7304s00 tsec,
           w83b19s00 tsind,
           w83b18s00 tdif
     WHERE tact.version_016 =
              (SELECT MAX (version_016)
                 FROM w83b16s00 act
                WHERE tact.n_acta_016 = act.n_acta_016
                  AND tact.ano_acta_016 = act.ano_acta_016
                  AND tact.c_territ_016 = act.c_territ_016
                  AND act.validada_016 = 1)
       --AND tact.f_baja_016 IS NULL
       AND tact.n_acttot_016 IS NULL
       AND tact.n_regdef_016 IS NOT NULL
       --AND tact.fregdef_016 IS NOT NULL
       AND tact.id_centro_016 = tcent.ccen_001
       --AND tcent.cnae_001 = tcnae.idcnae(+)
       AND RPAD(replace(tcent.cnae_001,' ','0') ,4,'0')    = tcnae.idcnae(+)
       AND tcent.secc_001 = tcnae.idsector(+)
       AND tsec.secc_004 = tcent.secc_001
       AND tact.validada_016 = 1
       AND tact.n_acta_016 = tdif.n_acta_018(+)
       AND tact.ano_acta_016 = tdif.ano_acta_018(+)
       AND tact.c_territ_016 = tdif.c_territ_018(+)
       AND tact.version_016 = tdif.version_018(+)
       AND tdif.c_sindi_018 = tsind.c_sindi_019)
   ORDER BY idsector, cnae_001, c_territ_016, ano_acta_016, n_acta_016,
    version_016;
 
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSCNAEHIST" ("NACTA", "ANOACTA", "TERRIT", "VER", "NCENTRO", "TOTALELECTORES", "FELEC", "FECHAREGISTRO", "IDCNAE", "SECTOR", "DESCSECTOR", "DESCCNAE", "FECHAACTU", "C_SINDI_024", "C_COLEG_024", "N_VOTOS_024", "N_DELH_024", "N_DELM_024", "SIGLAS_019", "FECHABAJA") AS 
  (SELECT tact.n_acta_016,
    tact.ano_acta_016,
    tact.c_territ_016,
    tact.version_016,
    tact.id_centro_016,
    tact.totelec_016,
    tact.f_elecc_016,
    tact.fregdef_016,    
    tcent.cnae_001,
    tcnae.idsector,
    tsec.desc_004,
    NVL (tcnae.desccnae, 'cnae desconocido-'
    || tcent.cnae_001),
    tact.factu_016,
    tsind.c_sindi_019,
    tesc.c_coleg_024,
    SUM (papeletas.vota_044),
    tesc.n_delh_024,
    tesc.n_delm_024,
    tsind.siglas_019,
    tact.f_baja_016
  FROM w83b16t00 tact,
    w83b.j7301s01 tcent,
    w83b24s00 tesc,
    w83bcnae tcnae,
    w83b.j7304s00 tsec,
    w83b19s00 tsind,
    w83b44s00 papeletas
  WHERE --tact.f_baja_016 IS NULL
    --AND
    tact.n_acttot_016   IS NULL
  AND tact.n_regdef_016 IS NOT NULL
    --AND tact.fregdef_016 IS NOT NULL
  AND tact.id_centro_016 = tcent.ccen_001
  AND RPAD(replace(tcent.cnae_001,' ','0') ,4,'0')    = tcnae.idcnae(+)
  AND tcent.secc_001     = tcnae.idsector(+)
  AND tsec.secc_004      = tcent.secc_001
  AND tact.validada_016  = 1
  AND tact.n_acta_016    = tesc.n_acta_024(+)
  AND tact.ano_acta_016  = tesc.ano_acta_024(+)
  AND tact.c_territ_016  = tesc.c_territ_024(+)
  AND tact.version_016   = tesc.version_024(+)
  AND tesc.n_acta_024    = papeletas.n_acta_044(+)
  AND tesc.ano_acta_024  = papeletas.ano_acta_044(+)
  AND tesc.c_territ_024  = papeletas.c_territ_044(+)
  AND tesc.version_024   = papeletas.version_044(+)
  AND tesc.c_sindi_024   = tsind.c_sindi_019(+)
  GROUP BY tact.n_acta_016,
    tact.ano_acta_016,
    tact.c_territ_016,
    tact.version_016,
    tact.id_centro_016,
    tact.totelec_016,
    tact.f_elecc_016,
    tact.fregdef_016,
    tcent.cnae_001,     
    tcnae.idsector,
    tsec.desc_004,
    NVL (tcnae.desccnae, 'cnae desconocido-'
    || tcent.cnae_001),
    tact.factu_016,
    tsind.c_sindi_019,
    tesc.c_coleg_024,
    tesc.n_delh_024,
    tesc.n_delm_024,
    tsind.siglas_019,
    tact.f_baja_016
  )
UNION ALL
  (SELECT tact.n_acta_016,
    tact.ano_acta_016,
    tact.c_territ_016,
    tact.version_016,
    tact.id_centro_016,
    tact.totelec_016,
    tact.f_elecc_016,
    tact.fregdef_016,
    tcent.cnae_001,    
    tcnae.idsector,
    tsec.desc_004,
    NVL (tcnae.desccnae, 'cnae desconocido-'
    || tcent.cnae_001),
    tact.factu_016,
    tsind.c_sindi_019,
    tdif.c_coleg_018,
    0 AS n_votos_024,
    tdif.n_delh_018,
    tdif.n_delm_018,
    tsind.siglas_019,
    tact.f_baja_016
  FROM w83b16t00 tact,
    w83b.j7301s01 tcent,
    w83b18s00 tdif,
    w83bcnae tcnae,
    w83b.j7304s00 tsec,
    w83b19s00 tsind
  WHERE --tact.f_baja_016 IS NULL
    --AND
    tact.n_acttot_016 IS NULL
    --AND tact.fregdef_016 IS NOT NULL
  AND tact.n_regdef_016 IS NOT NULL
  AND tact.id_centro_016 = tcent.ccen_001
  AND RPAD(replace(tcent.cnae_001,' ','0') ,4,'0')    = tcnae.idcnae(+)
  AND tcent.secc_001     = tcnae.idsector(+)
  AND tsec.secc_004      = tcent.secc_001
  AND tact.validada_016  = 1
  AND tact.n_acta_016    = tdif.n_acta_018(+)
  AND tact.ano_acta_016  = tdif.ano_acta_018(+)
  AND tact.c_territ_016  = tdif.c_territ_018(+)
  AND tact.version_016   = tdif.version_018(+)
  AND tdif.c_sindi_018   = tsind.c_sindi_019
  )
ORDER BY idsector,
  cnae_001,
  c_territ_016,
  ano_acta_016,
  n_acta_016,
  version_016;
 
CREATE OR REPLACE FORCE VIEW "W83B"."W83BCNAE" ("IDCNAE", "IDSECTOR", "DESCCNAE") AS 
  SELECT    distinct cnae.divi_003
          || DECODE (cnae.grup_003, ' ', '0', cnae.grup_003)
          || DECODE (cnae.clas_003, ' ', '0', cnae.clas_003),
          cnae.secc_003, cnae.desc_003
     FROM j7303s00 cnae;

   /